# Simple test function to test out SLICOT interface
# RMM, 28 May 09

from scipy import *             # Load the scipy functions
from control import *           # Load the controls systems library
from slicot import ab01md       # Load test function interface

# Parameters defining the system
m = 250.0			# system mass
k = 40.0			# spring constant
b = 60.0			# damping constant

# System matrices
A = matrix([[1, -1, 1.], [1, -k/m, -b/m], [1, 1, 1]])
B = matrix([[0], [1/m], [1]])
C = matrix([[1., 0, 1.]])
sys = ss(A, B, C, 0);

Ac, Bc, ncont, info = ab01md('I', A, B)

