%-------------------------------------------------------
function [H, GT, compatibility] = data_association(map, observations, step),
%-------------------------------------------------------
global configuration ground;

% individual compatibility
prediction = predict_observations (map);
compatibility = compute_compatibility (prediction, observations);

% ground truth
GT = ground_solution(map, observations);
disp(['GROUND  TRUTH: ' sprintf('%2d  ', GT)]);

% SELECT DATA ASSOCIATION ALGORITHM HERE
%H = GT; % perfect data association Hypothesis = Ground Truth
H = NN (prediction, observations, compatibility); % Nearest Neighbor
%H = SINGLES (prediction, observations, compatibility); % Singles (for you to implement)
%H = JCBB (prediction, observations, compatibility); % Joint Compatibility Branch and Bound

disp(['MY HYPOTHESIS: ' sprintf('%2d  ', H)]);
disp(['Correct (1/0)? ' sprintf('%2d  ', GT == H)]);
disp(' ');

draw_map (map, ground, step);
draw_observations (observations, ground, step);

draw_compatibility (prediction, observations, compatibility);

draw_hypothesis (prediction, observations, compatibility, H, configuration.name, 'b-');
draw_tables (compatibility, GT, H);
