function pf_tracking



global xVehicleTrue;
global UTrue;
global RTrue;
global ceiling_image;


ceiling_image = imread('ceiling.png');
ceiling_image=ceiling_image(:,:,1);

xVehicleTrue= [350;150;-pi/2];
UTrue = diag([0.01,0.01,1.5*pi/180]).^2;
RTrue = 3.^2;

xVehicleEst =[xVehicleTrue];
UEst = 2.0*UTrue;

nParticles=10000;
xVehicleParticles = repmat(xVehicleTrue,1,nParticles);


%length of experiment
nSteps = 450;

xOdomLast = GetOdometry(1);


figure(1)
clf
imshow(ceiling_image);
axis on
hold on

for k = 2:nSteps
    
    %do world iteration
    SimulateWorld(k);
    
    %figure out control
    xOdomNow = GetOdometry(k);
    u = tcomp(tinv(xOdomLast),xOdomNow);
    xOdomLast = xOdomNow;
    
    
    xVehicleParticles = MotionModelParticles(xVehicleParticles,u,UEst);


    
    
    z= GetObservation();
    h = ObservationModel(xVehicleParticles);
    
    
   
    nu = z - h;
    
    sigma = 5.0;
    weight = (2*pi*sigma^2)^-0.5 * exp(-(nu.^2./(2*sigma^2)));
    
    
    figure(1)
    clf
    imshow(ceiling_image);
    axis on
    hold on
    plot(xVehicleParticles(1,:),xVehicleParticles(2,:),'g+')
    plot(xVehicleTrue(1),xVehicleTrue(2),'w+')
    %DoVehicleGraphics(xVehicleEst,eye(3),3,[0 1]);
    drawnow
%     figure(2)
%     subplot(2,1,1)
%     imshow(uint8(z*ones(50,50)));
%     ylabel('observation')
%     subplot(2,1,2)
%     %imshow(reshape(uint8(h),10,10));
%     ylabel('prediction')
%     drawnow
%     
    xVehicleParticles = ResampleParticles(xVehicleParticles,weight);
    
end
    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xVehicleParticlesNew = ResampleParticles(xVehicleParticles,weight)

nParticles = size(xVehicleParticles,2);

cumulative = [0 cumsum(weight)];
r = rand(1,nParticles)*cumulative(end);

[n idx] =histc(r,cumulative);


xVehicleParticlesNew=xVehicleParticles(:,idx);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xVehicleParticlesNew = MotionModelParticles(xVehicleParticles,u,UEst)

nParticles = size(xVehicleParticles,2);

Noise = sqrt(UEst)*randn(3,nParticles);

uNoise=tcomp_batch(u,Noise);

xVehicleParticlesNew=tcomp_batch(xVehicleParticles,uNoise);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function tac = tcomp_batch(tab,tbc)

theta_new = tab(3,:)+tbc(3,:);
theta_new = AngleWrap(theta_new);

s = sin(tab(3,:));
c = cos(tab(3,:));


tac = [tab(1,:) + c .* tbc(1,:) - s .* tbc(2,:);
       tab(2,:) + s .* tbc(1,:) + c .* tbc(2,:);
       theta_new];


    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function zMeasured = GetObservation()
global xVehicleTrue;
global RTrue;

zTrue = ObservationModel(xVehicleTrue);
Noise = sqrt(RTrue)*randn(1);

zMeasured = zTrue + Noise;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function h = ObservationModel(xVehicle)
global ceiling_image;

c=round(xVehicle(1,:));
r=round(xVehicle(2,:));
[height width] = size(ceiling_image);
c=min(max(1,c),width);
r=min(max(1,r),height);
idx = r+(c-1)*height;
h = double(ceiling_image(idx));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SimulateWorld(k)
global xVehicleTrue;
u = GetRobotControl(k);
xVehicleTrue = tcomp(xVehicleTrue,u);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [xnow] = GetOdometry(k)
persistent LastOdom; %internal to robot low-level controller
global UTrue;
if(isempty(LastOdom))
    global xVehicleTrue;
    LastOdom = xVehicleTrue;
end;
u = GetRobotControl(k);
xnow =tcomp(LastOdom,u);
uNoise = sqrt(UTrue)*randn(3,1);
xnow = tcomp(xnow,uNoise);
LastOdom = xnow;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function u = GetRobotControl(k)
u = [0; 1.3 ; 0.9*pi/180];
